#!/usr/bin/env python3
import json, sys, glob
from pathlib import Path

target = (sys.argv[1] if len(sys.argv)>1 else "lenses").lower()
base = Path(f"work/bins/{target}")
idx = json.loads((base/"index.json").read_text())

done = {Path(p).stem.replace(f"prestack_{target}_","")
        for p in glob.glob(str(base/f"prestack_{target}_*.csv"))}

total_rows = sum(b["rows"] for b in idx)
done_rows  = sum(b["rows"] for b in idx if Path(b["path"]).stem in done)
left = [(b["rg_bin"], b["ms_bin"], b["rows"])
        for b in idx if Path(b["path"]).stem not in done]

print(f"{target}: {len(done)}/{len(idx)} bins done "
      f"({done_rows/total_rows*100:.1f}% lens-weighted)")
print("Remaining bins (# lenses):")
for rg, ms, n in left:
    print(f"  {rg} × {ms}: {n:,}")
print(f"Total lenses left: {sum(n for _,_,n in left):,}")
